local P1, P2, P1Score, P2Score
local P1xpos, P2xpos, P1ypos, P2ypos
local difficulty, sTable
local songName= GAMESTATE:GetCurrentSong():GetSongDir() -- Looks for Song
local movX = 250
local movY = -100
local movZ = -400

local IsEditMode = function()
	local topscreen = SCREENMAN:GetTopScreen()
	if not topscreen then
	  lua.ReportScriptError("IsEditMode() check failed to run because there is no Screen yet.")
	  return nil
	end
  
	return (THEME:GetMetric(topscreen:GetName(), "Class") == "ScreenEdit")
  end
  
  -- helper function for returning the player AF
  -- works as expected in ScreenGameplay
  -- uses IsEditMode() to find the player AF if we're in EditMode
  --     arguments:  pn is a number like 1 or 2
  --     returns:    the "PlayerP1" or "PlayerP2" ActorFrame in ScreenGameplay
  --                 or, the unnamed equivalent in ScrenEdit
  local GetPlayerAF = function(pn)
	local topscreen = SCREENMAN:GetTopScreen()
	if not topscreen then
	  lua.ReportScriptError("GetPlayerAF() failed to find the player ActorFrame because there is no Screen yet.")
	  return nil
	end
  
	local playerAF = nil
  
	-- Get the player ActorFrame on ScreenGameplay
	-- It's a direct child of the screen and named "PlayerP1" for P1
	-- and "PlayerP2" for P2.
	-- This naming convention is hardcoded in the SM5 engine.
	--
	-- ScreenEdit does not name its player ActorFrame, but we can still find it.
  
	-- find the player ActorFrame in edit mode
	if IsEditMode() then
	  -- loop through all nameless children of topscreen
	  -- and find the one that contains the NoteField
	  -- which is thankfully still named "NoteField"
	  for _,nameless_child in ipairs(topscreen:GetChild("")) do
		if nameless_child:GetChild("NoteField") then
		  playerAF = nameless_child
		  break
		end
	  end
  
	-- find the player ActorFrame in gameplay
	else
	  local player_af = topscreen:GetChild("PlayerP"..pn)
	  if player_af then
		playerAF = player_af
	  end
	end
  
	return playerAF
  end

local version = tonumber(string.match(ProductID(),'%d+%.?%d*$')) or 5.0;
if version > 5.1 then
	SCREENMAN:SystemMessage('Sorry, this song was made for SM 5.1');
end

local WideScale = function(AR4_3, AR16_9)
	-- return scale( SCREEN_WIDTH, 640, 854, AR4_3, AR16_9 )
	local w = 480 * PREFSMAN:GetPreference("DisplayAspectRatio")
	return scale( w, 640, 854, AR4_3, AR16_9 )
 end

local function isEditMode()
	local screen = SCREENMAN:GetTopScreen()
	if not screen then
	   return nil
	end
	local screen = SCREENMAN:GetTopScreen()	
	return (THEME:GetMetric(screen:GetName(), "Class") == "ScreenEdit")
end

local SlightFade = function(alpha)
    
	for player in ivalues(GAMESTATE:GetHumanPlayers()) do
	   
        if isEditMode() then 
		  -- Get specificially the NoteField out of the player ActorFrame.
		  -- It is a named child ("NoteField"), hardcoded in the SM5 engine.
		  local notefield = GetPlayerAF(1)
		  
		  -- if the notefield was found (it should be, but hey)
		  if notefield then
			 
			 -- for each column in the NoteField
			 -- there are 4 columns in dance single, 8 in dance double, 5 in pump single, etc.
			 for i, column in ipairs(notefield:get_column_actors()) do
				column:diffusealpha(alpha)
			 end
		  end
            return;
        end
	   -- Get the player ActorFrame on ScreenGameplay.
	   -- It's a direct child of the screen and named "PlayerP1" for P1
	   -- and "PlayerP2" for P2.  This is currently hardcoded in the SM5 engine.
	   --
	   -- note: ScreenEdit does not name its notefield actor and I don't 
	   --       know how to get a reference to it from Lua.
	   local name = ("Player%s"):format( ToEnumShortString(player) )
	   
	   -- get a reference to the player ActorFrame
	   local player_af = SCREENMAN:GetTopScreen():GetChild( name )
	   
	   -- if the player ActorFrame was found (it won't be in Edit Mode)
	   if player_af then
		  -- Get specificially the NoteField out of the player ActorFrame.
		  -- It is a named child ("NoteField"), hardcoded in the SM5 engine.
		  local notefield = player_af:GetChild("NoteField")
		  
		  -- if the notefield was found (it should be, but hey)
		  if notefield then
			 
			 -- for each column in the NoteField
			 -- there are 4 columns in dance single, 8 in dance double, 5 in pump single, etc.
			 for i, column in ipairs(notefield:get_column_actors()) do
				column:diffusealpha(alpha)
			 end
		  end
	   end
	end
 end

 local function Handler_mod_internal(str, pn) -- Applies Players options to not be disabled-
	local ps= GAMESTATE:GetPlayerState(pn)
	local pmods= ps:GetPlayerOptionsString('ModsLevel_Song')
	ps:SetPlayerOptions('ModsLevel_Song', pmods .. ', ' .. str)
	--GAMESTATE:ApplyGameCommand('mod,'..str, pn)
end

local function Handler_mod(str) -- Looks for many players are on the screen 
	--if (isEditMode()) then return end
	for i=1,2 do
		Handler_mod_internal(str, 'PlayerNumber_P' .. i)
	end
end

local function Handler_init() -- Useful for command shorcuts

	if SCREENMAN:GetTopScreen():GetChild('PlayerP1') and not isEditMode() then
		P1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1')
	--	P1:visible(false)
		if P1 then
			P1xpos=P1:GetX();
			P1ypos=P1:GetY();
		end
		P1:accelerate(0.25):Center():addz(-100)
	end
	if SCREENMAN:GetTopScreen():GetChild('PlayerP2') and not isEditMode() then
		P2 = SCREENMAN:GetTopScreen():GetChild('PlayerP2')
	--	P2:visible(false)
		if P2 then
			P2xpos=P2:GetX();
			P2ypos=P2:GetY();
		end
		P2:accelerate(0.25):Center():addz(-100)
	end
	if SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P1Score') and not isEditMode() then
		P1Score = SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P1Score')
	end
	if SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P2Score')and not isEditMode() then
		P2Score = SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P2Score')
	end


	fgcurcommand = 0;
	wndr_skewx=0.3;
	checked = false;
	--lua course :D	/ timed mod management	
	curmod = 1;		
	--{beat,'mod'},
	mods = {
		{0,'*20 600% Confusion'},
        {1, '*0.25 10% Beat, *4 no Confusion'},
        {64, '*0.25 60% Beat'},
		{94, '*0.25 10% Beat'},
		{288, '*0.25 150% Beat'},



	}
	--SCREAMING GUMBALL / timed message broadcaster
	curmessage = 1;
	--{beat,message,ignoreIfAhead}
	messages = {
        {31, "PreCochito"},
        {36, "PreCochito2"},
        {94, "PreUnCochito"},
		{160, "Cochito1"},
        {164, "Cochito2"},
        {222, "UnCochito"}
	}
	
end

local function Handler_update() -- Updates the command to look for the players at the start of the song.

	if GAMESTATE:GetSongBeat()>=0 and not checked then
		
		screen = SCREENMAN:GetTopScreen()
		
		checked = true;
		
	end

	local beat = GAMESTATE:GetSongBeat()

	-- Collect all the mods that will be applied in this frame into one string.
	-- Mod tweening doesn't work correctly if the mods are in seperate commands.
	local mods_this_frame= {}
	local function add_mod(mod_str)
		mods_this_frame[#mods_this_frame+1]= mod_str
	end
	local function execute_mods()
		if #mods_this_frame <= 0 then return end
		local total_mod_str= ""
		for i, ms in ipairs(mods_this_frame) do
			if #total_mod_str > 0 then
				total_mod_str= total_mod_str .. ", "
			end
			total_mod_str= total_mod_str .. ms
		end
		Handler_mod(total_mod_str)
	end
	
	while curmod<= #mods and GAMESTATE:GetSongBeat()>=mods[curmod][1] do
		add_mod(mods[curmod][2])
		curmod = curmod+1
	end

	execute_mods()
	
	while curmessage<= #messages and GAMESTATE:GetSongBeat()>=messages[curmessage][1] do
		if messages[curmessage][3] and GAMESTATE:GetSongBeat()>=messages[curmessage][1]+5 then
			curmessage = curmessage+1;
		else
			MESSAGEMAN:Broadcast(messages[curmessage][2])
			curmessage = curmessage+1;
		end
	end
end
local last_score_x = 0
local musicrate = GAMESTATE:GetSongOptionsObject("ModsLevel_Song"):MusicRate()
return Def.ActorFrame{

	OnCommand= function(self)
			Handler_init()
			self:SetUpdateFunction(Handler_update)
			local screen = SCREENMAN:GetTopScreen()
		end,
	Def.Quad{
		Name= "I may be sleeping, but I preserve the world.",
		InitCommand= cmd(visible,false),
		OnCommand= cmd(sleep,1000),
        Cochito1MessageCommand=function(self)
        end,
		PreCochitoMessageCommand=function(self)
			if GetPlayerAF(1) then
				GetPlayerAF(1):linear(1):x(P1xpos):y(P1ypos):addz(100)
			end
			if GetPlayerAF(2) then
				GetPlayerAF(2):linear(1):addx(50)
			end
		end,
		PreCochito2MessageCommand=function(self)
			if GetPlayerAF(2) then
				GetPlayerAF(2):linear(1):x(P2xpos):y(P2ypos):addz(100)
			end
		end,
	},
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if P1Score and not isEditMode() then
				self:SetTarget(P1Score)
			end
		end
	},
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if P2Score and not isEditMode() then
				self:SetTarget(P2Score)
			end
		end
	},

-------------------------------
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if GetPlayerAF(1) then
			 	self:SetTarget(GetPlayerAF(1))
            end
		end,
        Cochito1MessageCommand=function(self)
            if GetPlayerAF(1) then
                GetPlayerAF(1):linear(4):addz(-300)
                self:linear(2):addx(-1 * movX):addy(movY):addz(movZ)
            end
        end,
        UnCochitoMessageCommand=function(self)
            if GetPlayerAF(1) then
                GetPlayerAF(1):linear(1):addz(300)
                self:linear(0.5):addx(movX):addy(-1*movY):addz(-1*movZ)
            end
        end,
	},
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if GetPlayerAF(1) then
			 	self:SetTarget(GetPlayerAF(1))
			end
		end,
        Cochito2MessageCommand=function(self)
            if GetPlayerAF(1) then
                self:linear(2):addx(movX):addy(movY):addz(movZ)
            end
        end,
        UnCochitoMessageCommand=function(self)
            if GetPlayerAF(1) then
                self:linear(0.5):addx(-1*movX):addy(-1*movY):addz(-1*movZ)
            end
        end,
	},
    Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if GetPlayerAF(1) then
			 	self:SetTarget(GetPlayerAF(1))
			end
		end,
  
	},

    -------------------------------
    Def.ActorProxy {
        OnCommand = function(self)
            self:queuecommand('Set')
        end,
        SetCommand = function(self)
            if GetPlayerAF(2) then  
                self:SetTarget(GetPlayerAF(2))
            end
        end,
        Cochito1MessageCommand=function(self)
            if GetPlayerAF(2) then
                GetPlayerAF(2):linear(4):addz(-300)
                self:linear(2):addx(movX):addy(movY):addz(movZ)
            end
        end,
        UnCochitoMessageCommand=function(self)
            if GetPlayerAF(2) then
                GetPlayerAF(2):linear(1):addz(300)
                self:linear(0.5):addx(-1*movX):addy(-1*movY):addz(-1*movZ)
            end
        end,
    },
    -------------------------------
    Def.ActorProxy {
        OnCommand = function(self)
            self:queuecommand('Set')
        end,
        SetCommand = function(self)
            if GetPlayerAF(2) then
                self:SetTarget(GetPlayerAF(2))
            end
        end,
        Cochito2MessageCommand=function(self)
            if GetPlayerAF(2) then
                self:linear(2):addx(-1*movX):addy(movY):addz(movZ)
            end
        end,
        UnCochitoMessageCommand=function(self)
            if GetPlayerAF(2) then
                self:linear(0.5):addx(movX):addy(-1*movY):addz(-1*movZ)
            end
        end
    },
    Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if GetPlayerAF(2) then
			 	self:SetTarget(GetPlayerAF(2))
			end
		end,
  
	},


	-- MIDDLE
	
 }